////////////////////////////////////////////////////////////////
// Brick
////////////////////////////////////////////////////////////////
// (c) 1989-2010 MAXON Computer GmbH, all rights reserved
////////////////////////////////////////////////////////////////

CONTAINER xbrick
{
	NAME xbrick;

	INCLUDE Mpreview;
	INCLUDE Xbase;

	GROUP ID_SHADERPROPERTIES
	{
		REAL	BRICK_SCALE											{ UNIT PERCENT; MIN 0.0; STEP 1.0; }
		REAL	BRICK_WIDTH											{ UNIT PERCENT; MIN 0; STEP 0.1; }
		REAL	BRICK_HEIGHT										{ UNIT PERCENT; MIN 0; STEP 0.1; }

		SEPARATOR															{ LINE; }

		REAL	BRICK_SHIFT											{ UNIT PERCENT; STEP 1.0; }
		LONG	BRICK_SHIFT_RESET								{ MIN 0; }

		SEPARATOR															{ LINE; }

		LONG	BRICK_HALFWIDTH									{ MIN 0; }

		REAL	BRICK_HALFWIDTH_SHIFT						{ UNIT PERCENT; STEP 1.0; }

		BOOL	BRICK_ALTCOL_BALANCE_HPERIOD		{  }

		SEPARATOR	BRICK_DISPLACEMENTMODE			{  }

		GROUP
		{
			COLUMNS 2;

			BOOL	BRICK_DISPLACEMENTMODE_ENABLE				{  }
			STATICTEXT	{ JOINENDSCALE; }

			REAL	BRICK_DISPLACEMENTMODE_RANDOM_HEIGHT		{ UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; }
			STATICTEXT	{ JOINENDSCALE; }

			REAL	BRICK_DISPLACEMENTMODE_RANDOM_SLOPE			{ UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; }
			STATICTEXT	{ JOINENDSCALE; }

			LONG	BRICK_DISPLACEMENTMODE_SLOPE_MODE
			{
				CYCLE
				{
					BRICK_DISPLACEMENTMODE_MODE_SLOPE_RANDOM;
					BRICK_DISPLACEMENTMODE_MODE_SLOPE_LEFT;
					BRICK_DISPLACEMENTMODE_MODE_SLOPE_RIGHT;
					BRICK_DISPLACEMENTMODE_MODE_SLOPE_UP;
					BRICK_DISPLACEMENTMODE_MODE_SLOPE_DOWN;
				}
			}
			STATICTEXT	{  }

			LONG	BRICK_DISPLACEMENTMODE_SEED							{ MIN 0; }
			STATICTEXT	{  }
		}
	}

	GROUP BRICK_GROUP_COLOR
	{
		COLUMNS 2;

		GRADIENT	BRICK_COL										{ COLOR; ICC_BASEDOCUMENT; }
		STATICTEXT	{ JOINENDSCALE; }

		SHADERLINK	BRICK_TEX_LINK						{  }
		STATICTEXT	{ JOINENDSCALE; }

		GROUP	BRICK_TEX_DETAILGROUP
		{
			COLUMNS 2;

			REAL				BRICK_TEX_OFFSET					{ UNIT PERCENT; STEP 1.0; }
			BOOL				BRICK_TEX_OFFSET_RANDOM		{ }

			REAL				BRICK_TEX_SCALE						{ UNIT PERCENT; MIN 0.0; STEP 1.0; }
			STATICTEXT	{ }

			BOOL				BRICK_TEX_FLIP						{  }
			STATICTEXT	{ }

			REAL				BRICK_TEX_OPACITY					{ UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; }
			STATICTEXT	{ }

			LONG				BRICK_TEX_BLENDMODE				{
																							CYCLE
																							{
																								BRICK_BLENDMODE_NORMAL;
																								BRICK_BLENDMODE_MULTIPLY;
																								BRICK_BLENDMODE_OVERLAY;
																								BRICK_BLENDMODE_DODGE;
																								BRICK_BLENDMODE_BURN;
																								BRICK_BLENDMODE_LIGHTEN;
																								BRICK_BLENDMODE_DARKEN;
																								BRICK_BLENDMODE_COLOR;
																							}
																						}
			STATICTEXT	{ }
		}
		STATICTEXT	{ JOINENDSCALE; }

		SEPARATOR															{ LINE; }
		STATICTEXT	{ JOINENDSCALE; }

		GRADIENT	BRICK_ALTCOL								{ COLOR; ICC_BASEDOCUMENT; }
		STATICTEXT	{ JOINENDSCALE; }

		SHADERLINK	BRICK_ALTTEX_LINK					{  }
		STATICTEXT	{ JOINENDSCALE; }

		GROUP	BRICK_ALTTEX_DETAILGROUP
		{
			COLUMNS 2;

			REAL				BRICK_ALTTEX_OFFSET					{ UNIT PERCENT; STEP 1.0; }
			BOOL				BRICK_ALTTEX_OFFSET_RANDOM	{ }

			REAL				BRICK_ALTTEX_SCALE				{ UNIT PERCENT; MIN 0.0; STEP 1.0; }
			STATICTEXT	{ }

			BOOL				BRICK_ALTTEX_FLIP					{  }
			STATICTEXT	{ }

			REAL				BRICK_ALTTEX_OPACITY			{ UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; }
			STATICTEXT	{ }

			LONG				BRICK_ALTTEX_BLENDMODE		{
																							CYCLE
																							{
																								BRICK_BLENDMODE_NORMAL;
																								BRICK_BLENDMODE_MULTIPLY;
																								BRICK_BLENDMODE_OVERLAY;
																								BRICK_BLENDMODE_DODGE;
																								BRICK_BLENDMODE_BURN;
																								BRICK_BLENDMODE_LIGHTEN;
																								BRICK_BLENDMODE_DARKEN;
																								BRICK_BLENDMODE_COLOR;
																							}
																						}
			STATICTEXT	{ }
		}
		STATICTEXT	{ JOINENDSCALE; }

		SEPARATOR															{ LINE; }
		STATICTEXT	{ JOINENDSCALE; }

		LONG	BRICK_ALTCOL_VPERIOD						{ MIN 0; }
		STATICTEXT	{ }

		LONG	BRICK_ALTCOL_HPERIOD						{ MIN 0; }
		STATICTEXT	{ }

		SEPARATOR															{ LINE; }
		STATICTEXT	{ JOINENDSCALE; }

		REAL	BRICK_COL_NOISE_SCALE						{ UNIT PERCENT; STEP 0.1; }
		STATICTEXT	{ }

		SEPARATOR															{  }
		STATICTEXT	{ }

		REAL	BRICK_COL_DETAILS_INTENSITY			{ UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; }
		STATICTEXT	{ }

		REAL	BRICK_COL_DETAILS_SCALE					{ UNIT PERCENT; MIN 0.0; STEP 1.0; }
		STATICTEXT	{ }
	}

	GROUP BRICK_GROUP_GAPS
	{
		COLUMNS 2;

		GRADIENT	BRICK_GAPCOL								{ COLOR; ICC_BASEDOCUMENT; }
		STATICTEXT	{ JOINENDSCALE; }

		SHADERLINK	BRICK_GAPTEX_LINK					{  }
		STATICTEXT	{ JOINENDSCALE; }

		GROUP	BRICK_GAPTEX_DETAILGROUP
		{
			COLUMNS 2;

			REAL				BRICK_GAPTEX_SCALE				{ UNIT PERCENT; MIN 0.0; STEP 1.0; }
			STATICTEXT	{  }

			BOOL				BRICK_GAPTEX_FLIP					{  }
			STATICTEXT	{  }

			REAL				BRICK_GAPTEX_OPACITY			{ UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; }
			STATICTEXT	{  }

			LONG				BRICK_GAPTEX_BLENDMODE		{
																							CYCLE
																							{
																								BRICK_BLENDMODE_NORMAL;
																								BRICK_BLENDMODE_MULTIPLY;
																								BRICK_BLENDMODE_OVERLAY;
																								BRICK_BLENDMODE_DODGE;
																								BRICK_BLENDMODE_BURN;
																								BRICK_BLENDMODE_LIGHTEN;
																								BRICK_BLENDMODE_DARKEN;
																								BRICK_BLENDMODE_COLOR;
																							}
																						}
			STATICTEXT	{  }
		}
		STATICTEXT	{ JOINENDSCALE; }

		SEPARATOR															{ LINE; }
		STATICTEXT	{ JOINENDSCALE; }

		REAL	BRICK_GAPCOL_NOISE_SCALE				{ UNIT PERCENT; STEP 0.1; }
		STATICTEXT	{  }

		SEPARATOR															{ LINE; }
		STATICTEXT	{ JOINENDSCALE; }

		REAL	BRICK_DEPTH											{ UNIT PERCENT; MIN 0.0; STEP 0.1; }
		STATICTEXT	{  }

		REAL	BRICK_GAPSIZE										{ UNIT PERCENT; MIN 0.0; STEP 0.1; }
		STATICTEXT	{  }

		REAL	BRICK_GAPNOTCH									{ UNIT PERCENT; MIN -100.0; MAX 100.0; }
		STATICTEXT	{  }

		SEPARATOR															{ LINE; }
		STATICTEXT	{ JOINENDSCALE; }

		REAL	BRICK_NOISE_INTENSITY						{ UNIT PERCENT; MIN 0.0; MAX 100.0; STEP 1.0; }
		STATICTEXT	{  }

		REAL	BRICK_NOISE_SCALE								{ UNIT PERCENT; MIN 0.0; STEP 1.0; }
		STATICTEXT	{  }
	}

	GROUP	BRICK_GROUP_DIRT
	{
		COLUMNS 2;

		GROUP
		{
			COLUMNS 3;
			BOOL		BRICK_DIRT_ENABLE							{  }
			BOOL		BRICK_DIRT_ENABLE_BRICK				{  }
			BOOL		BRICK_DIRT_ENABLE_GAP					{  }
		}
		STATICTEXT	{ JOINENDSCALE; }

		SEPARATOR															{  }
		STATICTEXT	{  }

		REAL		BRICK_DIRT_OPACITY						{ UNIT PERCENT; MIN 0; MAX 100.0; CUSTOMGUI REALSLIDER; }
		STATICTEXT	{ JOINENDSCALE; }

		REAL		BRICK_DIRT_GAP_BLEND					{ UNIT PERCENT; MIN -100.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
		STATICTEXT	{ JOINENDSCALE; }

		REAL		BRICK_DIRT_BRICK_BLEND				{ UNIT PERCENT; MIN -100.0; MAX 100.0; CUSTOMGUI REALSLIDER; }
		STATICTEXT	{ JOINENDSCALE; }

		SEPARATOR															{ LINE; }
		STATICTEXT	{ JOINENDSCALE; }

		GRADIENT	BRICK_DIRT_COL							{ COLOR; ALPHA; ICC_BASEDOCUMENT; }
		STATICTEXT	{ JOINENDSCALE; }

		REAL		BRICK_DIRT_COL_SCALE					{ UNIT PERCENT; STEP 0.1; }
		STATICTEXT	{  }

		SEPARATOR															{ LINE; }
		STATICTEXT	{ JOINENDSCALE; }

		VECTOR	BRICK_DIRT_ALPHA_SHIFT				{ UNIT PERCENT; STEP 0.1; }
		STATICTEXT	{ JOINENDSCALE; }

		REAL		BRICK_DIRT_ALPHA_SCALE				{ UNIT PERCENT; STEP 0.1; }
		STATICTEXT	{  }

		REAL		BRICK_DIRT_ALPHA_OCT					{ MIN 0; MAX 10; STEP 0.1; }
		STATICTEXT	{  }

		SEPARATOR															{ LINE; }
		STATICTEXT	{ JOINENDSCALE; }

		SHADERLINK	BRICK_DIRTTEX_LINK				{  }
		STATICTEXT	{ JOINENDSCALE; }

		SHADERLINK	BRICK_DIRTTEX_COLOR_LINK	{  }
		STATICTEXT	{ JOINENDSCALE; }

		GROUP		BRICK_DIRTTEX_DETAILGROUP
		{
			VECTOR	BRICK_DIRTTEX_SHIFT						{ UNIT PERCENT; STEP 0.1; }

			REAL		BRICK_DIRTTEX_SCALE						{ UNIT PERCENT; STEP 0.1; }

			BOOL		BRICK_DIRTTEX_FLIP						{  }

			BOOL		BRICK_DIRTTEX_MULTIPLYCOLOR		{  }

			SEPARATOR															{  }

			BOOL		BRICK_DIRTTEX_ALPHA_INVERT		{  }

			REAL		BRICK_DIRTTEX_ALPHA_CONTRAST	{ UNIT PERCENT; MIN 0.0; }

			REAL		BRICK_DIRTTEX_ALPHA_BIAS			{ UNIT PERCENT; }
		}
		STATICTEXT	{ JOINENDSCALE; }

		SEPARATOR															{ LINE; }
		STATICTEXT	{ JOINENDSCALE; }

		REAL		BRICK_DIRTTEX_RAIN						{ UNIT PERCENT; MIN 0.0; MAX 5000.0; }
		LONG		BRICK_DIRTTEX_RAIN_SAMPLES		{ MIN 6; }

		BOOL		BRICK_DIRTTEX_RAIN_DOCOLOR		{  }
		STATICTEXT	{  }
	}
}
